#!/usr/bin/perl -w
use strict;

open IF, $ARGV[0];

# Vectors to store lat and lon from the log file
my @lat;
my @lon;
my @utc;

while (<IF>) {
    # Format for GPS Fix Data from EB-85A
    if ($_=~/GPGGA,([\d\.]+),([\d\.]+),([NS]),([\d\.]+),([EW])/) {
	# GPS telemetry has lat and lon in DDDMM.MMMM format and a
	# sector designation rather than signed decimal degrees
	my $utctime = $1;
	my $latddmm = $2;
	my $latsector = $3;
	my $londdmm = $4;
	my $lonsector = $5;

	# Get the degrees part:
	my $latdd = int( $latddmm / 100 );
	my $londd = int( $londdmm / 100 );

	# Get the minutes part:
	my $latmm = $latddmm - 100 * $latdd;
	my $lonmm = $londdmm - 100 * $londd;
	
	# Turn DDMM.MMMM into DDD.DDDDD format:
	$latdd = $latdd + $latmm/60.0;
	$londd = $londd + $lonmm/60.0;
	
	# Add sign for N/S and E/W sector:
	if ($latsector=~/S/) { $latdd = -$latdd; }
	if ($lonsector=~/W/) { $londd = -$londd; }

	# Just a little error check.  There are some corrupt lines in
	# the log files where some messages clobber each other.  Most
	# are corrupt enough that they don't parse above.  Note that
	# this little check will also fail if the legitimate
	# coordinates are outside the northwest corner of Nevada.
	#if ( ( abs($latdd - 40) > 1 ) or ( abs($londd + 119) > 1 ) )
	#{ print "Log corruption? $latdd $londd " . $_; }

	# Keep these coordinates
	push @utc, $utctime;
	push @lat, $latdd;
	push @lon, $londd;
    }
}

# Write a KML file
open OF, '>', $ARGV[1];


for (my $i=0; $i<$#lat; $i++) {
    print OF "$utc[$i],$lon[$i],$lat[$i]\n";
}

