function gps_sort( gps_data );

lat_to_meters = 110991.72617118986;
lon_to_meters = 88129.76289310472;

lat = gps_data(:,3);
lon = gps_data(:,2);
time = gps_data(:,1);

north_meters = lat * lat_to_meters;
west_meters = lon * lon_to_meters;

lat_mean = mean(lat)
lon_mean = mean(lon)

north_meters_mean = mean(north_meters)
west_meters_mean = mean(west_meters)

north_meters_std = std(north_meters)
west_meters_std = std(west_meters)

figure();

subplot(2,1,1);
plot(time,west_meters_mean-west_meters);
xlabel('Time (sec)');
ylabel('East of Mean (m)');
grid;


subplot(2,1,2);
plot(time,north_meters-north_meters_mean);
xlabel('Time (sec)');
ylabel('North of Mean (m)');
grid;


