function gps_sort( gps_data1, gps_data2 );

lat_to_meters = 110991.72617118986;
lon_to_meters = 88129.76289310472;

lat1 = gps_data1(:,3);
lon1 = gps_data1(:,2);
time1 = gps_data1(:,1);

north_meters1 = lat1 * lat_to_meters;
west_meters1 = lon1 * lon_to_meters;

lat_mean1 = mean(lat1)
lon_mean1 = mean(lon1)

north_meters_mean1 = mean(north_meters1)
west_meters_mean1 = mean(west_meters1)

north_meters_std1 = std(north_meters1)
west_meters_std1 = std(west_meters1)


lat2 = gps_data2(:,3);
lon2 = gps_data2(:,2);
time2 = gps_data2(:,1);

north_meters2 = lat2 * lat_to_meters;
west_meters2 = lon2 * lon_to_meters;

lat_mean2 = mean(lat2)
lon_mean2 = mean(lon2)

north_meters_mean2 = mean(north_meters2)
west_meters_mean2 = mean(west_meters2)

north_meters_std2 = std(north_meters2)
west_meters_std2 = std(west_meters2)


figure();

subplot(2,1,1);
plot(time1-min(time1),west_meters_mean1-west_meters1);
hold on;
plot(time2-min(time1),west_meters_mean1-west_meters2,'r');
xlabel('Time (sec)');
ylabel('East of Mean (m)');
grid;
hold off;


subplot(2,1,2);
plot(time1-min(time1),north_meters1-north_meters_mean1);
hold on;
plot(time2-min(time1),north_meters2-north_meters_mean1,'r');
xlabel('Time (sec)');
ylabel('North of Mean (m)');
grid;
hold off;

idx2 = 1;

timediff = [];
west_meters_diff = [];
north_meters_diff = [];

for idx1 = 1:size(time1)
    
    while (time1(idx1) > time2(idx2))
        if (idx2 < max(size(time2)))
            idx2 = idx2 + 1;
        else 
            break
        end
    end
    

    if (time1(idx1) == time2(idx2))
        timediff = [timediff;time1(idx1)];
        west_meters_diff = [west_meters_diff;west_meters1(idx1)-west_meters2(idx2)];
        north_meters_diff = [north_meters_diff;north_meters1(idx1)-north_meters2(idx2)];
    end
end
figure();

subplot(2,1,1);
plot(timediff-min(time1),west_meters_diff);
xlabel('Time (sec)');
ylabel('East Difference (m)');
grid;

subplot(2,1,2);
plot(timediff-min(time1),north_meters_diff);
xlabel('Time (sec)');
ylabel('North Difference (m)');
grid;

dist_meters = (west_meters_diff.^2+north_meters_diff.^2).^(0.5);

mean_dist_meters = mean(dist_meters)
std_dist_meters = std(dist_meters)

figure;
plot(timediff-min(time1),dist_meters);
xlabel('Time (sec)');
ylabel('Distance (m)');
grid;

figure;
hist(dist_meters,70);
title('Distance Histogram');
grid;

figure;
hist(west_meters_mean1-west_meters1,70)

