#!/usr/bin/perl -w
use strict;

open IF, $ARGV[0];

# Vectors to store lat and lon from the log file
my @lat;
my @lon;

while (<IF>) {
    # Format for GPS Fix Data from EB-85A
    if ($_=~/GPGGA,([\d\.]+),([\d\.]+),([NS]),([\d\.]+),([EW])/) {
	# GPS telemetry has lat and lon in DDDMM.MMMM format and a
	# sector designation rather than signed decimal degrees
	my $utctime = $1;
	my $latddmm = $2;
	my $latsector = $3;
	my $londdmm = $4;
	my $lonsector = $5;

	# Get the degrees part:
	my $latdd = int( $latddmm / 100 );
	my $londd = int( $londdmm / 100 );

	# Get the minutes part:
	my $latmm = $latddmm - 100 * $latdd;
	my $lonmm = $londdmm - 100 * $londd;
	
	# Turn DDMM.MMMM into DDD.DDDDD format:
	$latdd = $latdd + $latmm/60.0;
	$londd = $londd + $lonmm/60.0;
	
	# Add sign for N/S and E/W sector:
	if ($latsector=~/S/) { $latdd = -$latdd; }
	if ($lonsector=~/W/) { $londd = -$londd; }

	# Just a little error check.  There are some corrupt lines in
	# the log files where some messages clobber each other.  Most
	# are corrupt enough that they don't parse above.  Note that
	# this little check will also fail if the legitimate
	# coordinates are outside the northwest corner of Nevada.
	#if ( ( abs($latdd - 40) > 1 ) or ( abs($londd + 119) > 1 ) )
	#{ print "Log corruption? $latdd $londd " . $_; }

	# Keep these coordinates
	push @lat, $latdd;
	push @lon, $londd;
    }
}

# Write a KML file
open OF, '>', $ARGV[1];

# KML header
print OF "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
print OF "<kml xmlns=\"http://earth.google.com/kml/2.1\">\n";
# Folder for the path and position
print OF "<Document>\n";
print OF "        <name>ORB</name>\n";
print OF "        <open>1</open>\n";
print OF "        <Folder>\n";
# Final location from log
print OF "                <name>ORB Location</name>\n";
print OF "                <Placemark>\n";
print OF "                        <Style>\n";
print OF "                                <IconStyle>\n";
print OF "                                        <Icon>\n";
print OF "                                                <href>root://icons/palette-4.png</href>\n";
print OF "                                                <x>32</x>\n";
print OF "                                                <y>128</y>\n";
print OF "                                                <w>32</w>\n";
print OF "                                                <h>32</h>\n";
print OF "                                        </Icon>\n";
print OF "                                </IconStyle>\n";
print OF "                        </Style>\n";
print OF "                        <Point>\n";
print OF "                                <coordinates>$lon[$#lon],$lat[$#lat],0</coordinates>\n";
print OF "                        </Point>\n";
print OF "                </Placemark>\n";
print OF "        </Folder>\n";
# ORB path from log
print OF "        <Placemark>\n";
print OF "                <name>ORB Path</name>\n";
print OF "                <Style>\n";
print OF "                        <LineStyle>\n";
print OF "                                <color>ff00ff00</color>\n";
print OF "                                <width>2.5</width>\n";
print OF "                        </LineStyle>\n";
print OF "                </Style>\n";
print OF "                <LineString>\n";
print OF "                        <tessellate>1</tessellate>\n";
print OF "                        <coordinates>\n";
for (my $i=0; $i<$#lat; $i++) {
    print OF "$lon[$i],$lat[$i],0\n";
}
print OF "                        </coordinates>\n";
print OF "                </LineString>\n";
print OF "        </Placemark>\n";
print OF "</Document>\n";
print OF "</kml>\n";
